@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Subnet first address, scope, and/or last address.
 * @property first First address in the subnet.
 * @property last Last address in the subnet.
 * @property scope Block size (number of leading bits in the subnet mask).
 */
public data class EndpointPropertiesResponseSubnets(
    public val first: String? = null,
    public val last: String? = null,
    public val scope: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.EndpointPropertiesResponseSubnets): EndpointPropertiesResponseSubnets = EndpointPropertiesResponseSubnets(
            first = javaType.first().map({ args0 -> args0 }).orElse(null),
            last = javaType.last().map({ args0 -> args0 }).orElse(null),
            scope = javaType.scope().map({ args0 -> args0 }).orElse(null),
        )
    }
}
