@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Identifies the service being brought into the virtual network.
 * @property id A unique identifier of the service being referenced by the interface endpoint.
 */
public data class EndpointServiceResponse(
    public val id: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.EndpointServiceResponse): EndpointServiceResponse = EndpointServiceResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
        )
    }
}
