@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines a managed rule group to use for exclusion.
 * @property ruleGroupName The managed rule group for exclusion.
 * @property rules List of rules that will be excluded. If none specified, all rules in the group will be excluded.
 */
public data class ExclusionManagedRuleGroupResponse(
    public val ruleGroupName: String,
    public val rules: List<ExclusionManagedRuleResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ExclusionManagedRuleGroupResponse): ExclusionManagedRuleGroupResponse = ExclusionManagedRuleGroupResponse(
            ruleGroupName = javaType.ruleGroupName(),
            rules = javaType.rules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ExclusionManagedRuleResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
