@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Explicit Proxy Settings in Firewall Policy.
 * @property enableExplicitProxy When set to true, explicit proxy mode is enabled.
 * @property enablePacFile When set to true, pac file port and url needs to be provided.
 * @property httpPort Port number for explicit proxy http protocol, cannot be greater than 64000.
 * @property httpsPort Port number for explicit proxy https protocol, cannot be greater than 64000.
 * @property pacFile SAS URL for PAC file.
 * @property pacFilePort Port number for firewall to serve PAC file.
 */
public data class ExplicitProxyResponse(
    public val enableExplicitProxy: Boolean? = null,
    public val enablePacFile: Boolean? = null,
    public val httpPort: Int? = null,
    public val httpsPort: Int? = null,
    public val pacFile: String? = null,
    public val pacFilePort: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ExplicitProxyResponse): ExplicitProxyResponse = ExplicitProxyResponse(
            enableExplicitProxy = javaType.enableExplicitProxy().map({ args0 -> args0 }).orElse(null),
            enablePacFile = javaType.enablePacFile().map({ args0 -> args0 }).orElse(null),
            httpPort = javaType.httpPort().map({ args0 -> args0 }).orElse(null),
            httpsPort = javaType.httpsPort().map({ args0 -> args0 }).orElse(null),
            pacFile = javaType.pacFile().map({ args0 -> args0 }).orElse(null),
            pacFilePort = javaType.pacFilePort().map({ args0 -> args0 }).orElse(null),
        )
    }
}
