@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Specifies the peering configuration.
 * @property advertisedCommunities The communities of bgp peering. Specified for microsoft peering.
 * @property advertisedPublicPrefixes The reference to AdvertisedPublicPrefixes.
 * @property advertisedPublicPrefixesState The advertised public prefix state of the Peering resource.
 * @property customerASN The CustomerASN of the peering.
 * @property legacyMode The legacy mode of the peering.
 * @property routingRegistryName The RoutingRegistryName of the configuration.
 */
public data class ExpressRouteCircuitPeeringConfigResponse(
    public val advertisedCommunities: List<String>? = null,
    public val advertisedPublicPrefixes: List<String>? = null,
    public val advertisedPublicPrefixesState: String,
    public val customerASN: Int? = null,
    public val legacyMode: Int? = null,
    public val routingRegistryName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ExpressRouteCircuitPeeringConfigResponse): ExpressRouteCircuitPeeringConfigResponse = ExpressRouteCircuitPeeringConfigResponse(
            advertisedCommunities = javaType.advertisedCommunities().map({ args0 -> args0 }),
            advertisedPublicPrefixes = javaType.advertisedPublicPrefixes().map({ args0 -> args0 }),
            advertisedPublicPrefixesState = javaType.advertisedPublicPrefixesState(),
            customerASN = javaType.customerASN().map({ args0 -> args0 }).orElse(null),
            legacyMode = javaType.legacyMode().map({ args0 -> args0 }).orElse(null),
            routingRegistryName = javaType.routingRegistryName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
