@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Peering in an ExpressRouteCircuit resource.
 * @property azureASN The Azure ASN.
 * @property connections The list of circuit connections associated with Azure Private Peering for this circuit.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property expressRouteConnection The ExpressRoute connection.
 * @property gatewayManagerEtag The GatewayManager Etag.
 * @property id Resource ID.
 * @property ipv6PeeringConfig The IPv6 peering configuration.
 * @property lastModifiedBy Who was the last to modify the peering.
 * @property microsoftPeeringConfig The Microsoft peering configuration.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property peerASN The peer ASN.
 * @property peeredConnections The list of peered circuit connections associated with Azure Private Peering for this circuit.
 * @property peeringType The peering type.
 * @property primaryAzurePort The primary port.
 * @property primaryPeerAddressPrefix The primary address prefix.
 * @property provisioningState The provisioning state of the express route circuit peering resource.
 * @property routeFilter The reference to the RouteFilter resource.
 * @property secondaryAzurePort The secondary port.
 * @property secondaryPeerAddressPrefix The secondary address prefix.
 * @property sharedKey The shared key.
 * @property state The peering state.
 * @property stats The peering stats of express route circuit.
 * @property type Type of the resource.
 * @property vlanId The VLAN ID.
 */
public data class ExpressRouteCircuitPeeringResponse(
    public val azureASN: Int? = null,
    public val connections: List<ExpressRouteCircuitConnectionResponse>? = null,
    public val etag: String,
    public val expressRouteConnection: ExpressRouteConnectionIdResponse? = null,
    public val gatewayManagerEtag: String? = null,
    public val id: String? = null,
    public val ipv6PeeringConfig: Ipv6ExpressRouteCircuitPeeringConfigResponse? = null,
    public val lastModifiedBy: String,
    public val microsoftPeeringConfig: ExpressRouteCircuitPeeringConfigResponse? = null,
    public val name: String? = null,
    public val peerASN: Double? = null,
    public val peeredConnections: List<PeerExpressRouteCircuitConnectionResponse>,
    public val peeringType: String? = null,
    public val primaryAzurePort: String? = null,
    public val primaryPeerAddressPrefix: String? = null,
    public val provisioningState: String,
    public val routeFilter: SubResourceResponse? = null,
    public val secondaryAzurePort: String? = null,
    public val secondaryPeerAddressPrefix: String? = null,
    public val sharedKey: String? = null,
    public val state: String? = null,
    public val stats: ExpressRouteCircuitStatsResponse? = null,
    public val type: String,
    public val vlanId: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ExpressRouteCircuitPeeringResponse): ExpressRouteCircuitPeeringResponse = ExpressRouteCircuitPeeringResponse(
            azureASN = javaType.azureASN().map({ args0 -> args0 }).orElse(null),
            connections = javaType.connections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteCircuitConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            etag = javaType.etag(),
            expressRouteConnection = javaType.expressRouteConnection().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteConnectionIdResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            gatewayManagerEtag = javaType.gatewayManagerEtag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            ipv6PeeringConfig = javaType.ipv6PeeringConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.Ipv6ExpressRouteCircuitPeeringConfigResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            lastModifiedBy = javaType.lastModifiedBy(),
            microsoftPeeringConfig = javaType.microsoftPeeringConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteCircuitPeeringConfigResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            peerASN = javaType.peerASN().map({ args0 -> args0 }).orElse(null),
            peeredConnections = javaType.peeredConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.PeerExpressRouteCircuitConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            peeringType = javaType.peeringType().map({ args0 -> args0 }).orElse(null),
            primaryAzurePort = javaType.primaryAzurePort().map({ args0 -> args0 }).orElse(null),
            primaryPeerAddressPrefix = javaType.primaryPeerAddressPrefix().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            routeFilter = javaType.routeFilter().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            secondaryAzurePort = javaType.secondaryAzurePort().map({ args0 -> args0 }).orElse(null),
            secondaryPeerAddressPrefix = javaType.secondaryPeerAddressPrefix().map({ args0 ->
                args0
            }).orElse(null),
            sharedKey = javaType.sharedKey().map({ args0 -> args0 }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            stats = javaType.stats().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteCircuitStatsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
            vlanId = javaType.vlanId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
