@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Contains SKU in an ExpressRouteCircuit.
 * @property family The family of the SKU.
 * @property name The name of the SKU.
 * @property tier The tier of the SKU.
 */
public data class ExpressRouteCircuitSkuResponse(
    public val family: String? = null,
    public val name: String? = null,
    public val tier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ExpressRouteCircuitSkuResponse): ExpressRouteCircuitSkuResponse = ExpressRouteCircuitSkuResponse(
            family = javaType.family().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
