@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * ExpressRouteLink Mac Security Configuration.
 * @property cakSecretIdentifier Keyvault Secret Identifier URL containing Mac security CAK key.
 * @property cipher Mac security cipher.
 * @property cknSecretIdentifier Keyvault Secret Identifier URL containing Mac security CKN key.
 * @property sciState Sci mode enabled/disabled.
 */
public data class ExpressRouteLinkMacSecConfigResponse(
    public val cakSecretIdentifier: String? = null,
    public val cipher: String? = null,
    public val cknSecretIdentifier: String? = null,
    public val sciState: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ExpressRouteLinkMacSecConfigResponse): ExpressRouteLinkMacSecConfigResponse = ExpressRouteLinkMacSecConfigResponse(
            cakSecretIdentifier = javaType.cakSecretIdentifier().map({ args0 -> args0 }).orElse(null),
            cipher = javaType.cipher().map({ args0 -> args0 }).orElse(null),
            cknSecretIdentifier = javaType.cknSecretIdentifier().map({ args0 -> args0 }).orElse(null),
            sciState = javaType.sciState().map({ args0 -> args0 }).orElse(null),
        )
    }
}
