@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * ExpressRouteLink child resource definition.
 * @property adminState Administrative state of the physical port.
 * @property coloLocation Cololocation for ExpressRoute Hybrid Direct.
 * @property connectorType Physical fiber port type.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property interfaceName Name of Azure router interface.
 * @property macSecConfig MacSec configuration.
 * @property name Name of child port resource that is unique among child port resources of the parent.
 * @property patchPanelId Mapping between physical port to patch panel port.
 * @property provisioningState The provisioning state of the express route link resource.
 * @property rackId Mapping of physical patch panel to rack.
 * @property routerName Name of Azure router associated with physical port.
 */
public data class ExpressRouteLinkResponse(
    public val adminState: String? = null,
    public val coloLocation: String,
    public val connectorType: String,
    public val etag: String,
    public val id: String? = null,
    public val interfaceName: String,
    public val macSecConfig: ExpressRouteLinkMacSecConfigResponse? = null,
    public val name: String? = null,
    public val patchPanelId: String,
    public val provisioningState: String,
    public val rackId: String,
    public val routerName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ExpressRouteLinkResponse): ExpressRouteLinkResponse = ExpressRouteLinkResponse(
            adminState = javaType.adminState().map({ args0 -> args0 }).orElse(null),
            coloLocation = javaType.coloLocation(),
            connectorType = javaType.connectorType(),
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            interfaceName = javaType.interfaceName(),
            macSecConfig = javaType.macSecConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteLinkMacSecConfigResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            patchPanelId = javaType.patchPanelId(),
            provisioningState = javaType.provisioningState(),
            rackId = javaType.rackId(),
            routerName = javaType.routerName(),
        )
    }
}
