@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Firewall Policy Filter Rule.
 * @property action The action type of a Filter rule.
 * @property name The name of the rule.
 * @property priority Priority of the Firewall Policy Rule resource.
 * @property ruleConditions Collection of rule conditions used by a rule.
 * @property ruleType The type of the rule.
 * Expected value is 'FirewallPolicyFilterRule'.
 */
public data class FirewallPolicyFilterRuleResponse(
    public val action: FirewallPolicyFilterRuleActionResponse? = null,
    public val name: String? = null,
    public val priority: Int? = null,
    public val ruleConditions: List<Any>? = null,
    public val ruleType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.FirewallPolicyFilterRuleResponse): FirewallPolicyFilterRuleResponse = FirewallPolicyFilterRuleResponse(
            action = javaType.action().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyFilterRuleActionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
            ruleConditions = javaType.ruleConditions().map({ args0 -> args0 }),
            ruleType = javaType.ruleType(),
        )
    }
}
