@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * name and value of HTTP/S header to insert
 * @property headerName Contains the name of the header
 * @property headerValue Contains the value of the header
 */
public data class FirewallPolicyHttpHeaderToInsertResponse(
    public val headerName: String? = null,
    public val headerValue: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.FirewallPolicyHttpHeaderToInsertResponse): FirewallPolicyHttpHeaderToInsertResponse = FirewallPolicyHttpHeaderToInsertResponse(
            headerName = javaType.headerName().map({ args0 -> args0 }).orElse(null),
            headerValue = javaType.headerValue().map({ args0 -> args0 }).orElse(null),
        )
    }
}
