@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Intrusion detection bypass traffic specification.
 * @property description Description of the bypass traffic rule.
 * @property destinationAddresses List of destination IP addresses or ranges for this rule.
 * @property destinationIpGroups List of destination IpGroups for this rule.
 * @property destinationPorts List of destination ports or ranges.
 * @property name Name of the bypass traffic rule.
 * @property protocol The rule bypass protocol.
 * @property sourceAddresses List of source IP addresses or ranges for this rule.
 * @property sourceIpGroups List of source IpGroups for this rule.
 */
public data class FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsResponse(
    public val description: String? = null,
    public val destinationAddresses: List<String>? = null,
    public val destinationIpGroups: List<String>? = null,
    public val destinationPorts: List<String>? = null,
    public val name: String? = null,
    public val protocol: String? = null,
    public val sourceAddresses: List<String>? = null,
    public val sourceIpGroups: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsResponse): FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsResponse =
            FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsResponse(
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                destinationAddresses = javaType.destinationAddresses().map({ args0 -> args0 }),
                destinationIpGroups = javaType.destinationIpGroups().map({ args0 -> args0 }),
                destinationPorts = javaType.destinationPorts().map({ args0 -> args0 }),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
                sourceAddresses = javaType.sourceAddresses().map({ args0 -> args0 }),
                sourceIpGroups = javaType.sourceIpGroups().map({ args0 -> args0 }),
            )
    }
}
