@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The operation for configuring intrusion detection.
 * @property bypassTrafficSettings List of rules for traffic to bypass.
 * @property privateRanges IDPS Private IP address ranges are used to identify traffic direction (i.e. inbound, outbound, etc.). By default, only ranges defined by IANA RFC 1918 are considered private IP addresses. To modify default ranges, specify your Private IP address ranges with this property
 * @property signatureOverrides List of specific signatures states.
 */
public data class FirewallPolicyIntrusionDetectionConfigurationResponse(
    public val bypassTrafficSettings: List<FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsResponse>? = null,
    public val privateRanges: List<String>? = null,
    public val signatureOverrides: List<FirewallPolicyIntrusionDetectionSignatureSpecificationResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.FirewallPolicyIntrusionDetectionConfigurationResponse): FirewallPolicyIntrusionDetectionConfigurationResponse =
            FirewallPolicyIntrusionDetectionConfigurationResponse(
                bypassTrafficSettings = javaType.bypassTrafficSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsResponse.Companion.toKotlin(args0)
                    })
                }),
                privateRanges = javaType.privateRanges().map({ args0 -> args0 }),
                signatureOverrides = javaType.signatureOverrides().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyIntrusionDetectionSignatureSpecificationResponse.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
