@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Intrusion detection signatures specification states.
 * @property id Signature id.
 * @property mode The signature state.
 */
public data class FirewallPolicyIntrusionDetectionSignatureSpecificationResponse(
    public val id: String? = null,
    public val mode: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.FirewallPolicyIntrusionDetectionSignatureSpecificationResponse): FirewallPolicyIntrusionDetectionSignatureSpecificationResponse =
            FirewallPolicyIntrusionDetectionSignatureSpecificationResponse(
                id = javaType.id().map({ args0 -> args0 }).orElse(null),
                mode = javaType.mode().map({ args0 -> args0 }).orElse(null),
            )
    }
}
