@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Log Analytics Workspace for Firewall Policy Insights.
 * @property region Region to configure the Workspace.
 * @property workspaceId The workspace Id for Firewall Policy Insights.
 */
public data class FirewallPolicyLogAnalyticsWorkspaceResponse(
    public val region: String? = null,
    public val workspaceId: SubResourceResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.FirewallPolicyLogAnalyticsWorkspaceResponse): FirewallPolicyLogAnalyticsWorkspaceResponse = FirewallPolicyLogAnalyticsWorkspaceResponse(
            region = javaType.region().map({ args0 -> args0 }).orElse(null),
            workspaceId = javaType.workspaceId().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
