@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The private IP addresses/IP ranges to which traffic will not be SNAT.
 * @property autoLearnPrivateRanges The operation mode for automatically learning private ranges to not be SNAT
 * @property privateRanges List of private IP addresses/IP address ranges to not be SNAT.
 */
public data class FirewallPolicySNATResponse(
    public val autoLearnPrivateRanges: String? = null,
    public val privateRanges: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.FirewallPolicySNATResponse): FirewallPolicySNATResponse = FirewallPolicySNATResponse(
            autoLearnPrivateRanges = javaType.autoLearnPrivateRanges().map({ args0 -> args0 }).orElse(null),
            privateRanges = javaType.privateRanges().map({ args0 -> args0 }),
        )
    }
}
