@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Parameters that define the flow log format.
 * @property type The file type of flow log.
 * @property version The version (revision) of the flow log.
 */
public data class FlowLogFormatParametersResponse(
    public val type: String? = null,
    public val version: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.FlowLogFormatParametersResponse): FlowLogFormatParametersResponse = FlowLogFormatParametersResponse(
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
