@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes Forwarding Route.
 * @property backendPool A reference to the BackendPool which this rule routes to.
 * @property cacheConfiguration The caching configuration associated with this rule.
 * @property customForwardingPath A custom path used to rewrite resource paths matched by this rule. Leave empty to use incoming path.
 * @property forwardingProtocol Protocol this rule will use when forwarding traffic to backends.
 * @property odataType
 * Expected value is '#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration'.
 */
public data class ForwardingConfigurationResponse(
    public val backendPool: SubResourceResponse? = null,
    public val cacheConfiguration: CacheConfigurationResponse? = null,
    public val customForwardingPath: String? = null,
    public val forwardingProtocol: String? = null,
    public val odataType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ForwardingConfigurationResponse): ForwardingConfigurationResponse = ForwardingConfigurationResponse(
            backendPool = javaType.backendPool().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            cacheConfiguration = javaType.cacheConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.CacheConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            customForwardingPath = javaType.customForwardingPath().map({ args0 -> args0 }).orElse(null),
            forwardingProtocol = javaType.forwardingProtocol().map({ args0 -> args0 }).orElse(null),
            odataType = javaType.odataType(),
        )
    }
}
