@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines a managed rule group override setting.
 * @property action Describes the override action to be applied when rule matches.
 * @property enabledState Describes if the managed rule is in enabled or disabled state. Defaults to Disabled if not specified.
 * @property exclusions Describes the exclusions that are applied to this specific rule.
 * @property ruleId Identifier for the managed rule.
 */
public data class FrontDoorManagedRuleOverrideResponse(
    public val action: String? = null,
    public val enabledState: String? = null,
    public val exclusions: List<ManagedRuleExclusionResponse>? = null,
    public val ruleId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.FrontDoorManagedRuleOverrideResponse): FrontDoorManagedRuleOverrideResponse = FrontDoorManagedRuleOverrideResponse(
            action = javaType.action().map({ args0 -> args0 }).orElse(null),
            enabledState = javaType.enabledState().map({ args0 -> args0 }).orElse(null),
            exclusions = javaType.exclusions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ManagedRuleExclusionResponse.Companion.toKotlin(args0)
                })
            }),
            ruleId = javaType.ruleId(),
        )
    }
}
