@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines a managed rule set.
 * @property exclusions Describes the exclusions that are applied to all rules in the set.
 * @property ruleGroupOverrides Defines the rule group overrides to apply to the rule set.
 * @property ruleSetAction Defines the rule set action.
 * @property ruleSetType Defines the rule set type to use.
 * @property ruleSetVersion Defines the version of the rule set to use.
 */
public data class FrontDoorManagedRuleSetResponse(
    public val exclusions: List<ManagedRuleExclusionResponse>? = null,
    public val ruleGroupOverrides: List<FrontDoorManagedRuleGroupOverrideResponse>? = null,
    public val ruleSetAction: String? = null,
    public val ruleSetType: String,
    public val ruleSetVersion: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.FrontDoorManagedRuleSetResponse): FrontDoorManagedRuleSetResponse = FrontDoorManagedRuleSetResponse(
            exclusions = javaType.exclusions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ManagedRuleExclusionResponse.Companion.toKotlin(args0)
                })
            }),
            ruleGroupOverrides = javaType.ruleGroupOverrides().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.FrontDoorManagedRuleGroupOverrideResponse.Companion.toKotlin(args0)
                })
            }),
            ruleSetAction = javaType.ruleSetAction().map({ args0 -> args0 }).orElse(null),
            ruleSetType = javaType.ruleSetType(),
            ruleSetVersion = javaType.ruleSetVersion(),
        )
    }
}
