@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Defines top-level WebApplicationFirewallPolicy configuration settings.
 * @property customBlockResponseBody If the action type is block, customer can override the response body. The body must be specified in base64 encoding.
 * @property customBlockResponseStatusCode If the action type is block, customer can override the response status code.
 * @property enabledState Describes if the policy is in enabled or disabled state. Defaults to Enabled if not specified.
 * @property mode Describes if it is in detection mode or prevention mode at policy level.
 * @property redirectUrl If action type is redirect, this field represents redirect URL for the client.
 * @property requestBodyCheck Describes if policy managed rules will inspect the request body content.
 */
public data class FrontDoorPolicySettingsResponse(
    public val customBlockResponseBody: String? = null,
    public val customBlockResponseStatusCode: Int? = null,
    public val enabledState: String? = null,
    public val mode: String? = null,
    public val redirectUrl: String? = null,
    public val requestBodyCheck: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.FrontDoorPolicySettingsResponse): FrontDoorPolicySettingsResponse = FrontDoorPolicySettingsResponse(
            customBlockResponseBody = javaType.customBlockResponseBody().map({ args0 -> args0 }).orElse(null),
            customBlockResponseStatusCode = javaType.customBlockResponseStatusCode().map({ args0 ->
                args0
            }).orElse(null),
            enabledState = javaType.enabledState().map({ args0 -> args0 }).orElse(null),
            mode = javaType.mode().map({ args0 -> args0 }).orElse(null),
            redirectUrl = javaType.redirectUrl().map({ args0 -> args0 }).orElse(null),
            requestBodyCheck = javaType.requestBodyCheck().map({ args0 -> args0 }).orElse(null),
        )
    }
}
