@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A frontend endpoint used for routing.
 * @property customHttpsConfiguration The configuration specifying how to enable HTTPS
 * @property customHttpsProvisioningState Provisioning status of Custom Https of the frontendEndpoint.
 * @property customHttpsProvisioningSubstate Provisioning substate shows the progress of custom HTTPS enabling/disabling process step by step.
 * @property hostName The host name of the frontendEndpoint. Must be a domain name.
 * @property id Resource ID.
 * @property name Resource name.
 * @property resourceState Resource status.
 * @property sessionAffinityEnabledState Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'
 * @property sessionAffinityTtlSeconds UNUSED. This field will be ignored. The TTL to use in seconds for session affinity, if applicable.
 * @property type Resource type.
 * @property webApplicationFirewallPolicyLink Defines the Web Application Firewall policy for each host (if applicable)
 */
public data class FrontendEndpointResponse(
    public val customHttpsConfiguration: CustomHttpsConfigurationResponse,
    public val customHttpsProvisioningState: String,
    public val customHttpsProvisioningSubstate: String,
    public val hostName: String? = null,
    public val id: String? = null,
    public val name: String? = null,
    public val resourceState: String,
    public val sessionAffinityEnabledState: String? = null,
    public val sessionAffinityTtlSeconds: Int? = null,
    public val type: String,
    public val webApplicationFirewallPolicyLink: FrontendEndpointUpdateParametersResponseWebApplicationFirewallPolicyLink? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.FrontendEndpointResponse): FrontendEndpointResponse = FrontendEndpointResponse(
            customHttpsConfiguration = javaType.customHttpsConfiguration().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.CustomHttpsConfigurationResponse.Companion.toKotlin(args0)
            }),
            customHttpsProvisioningState = javaType.customHttpsProvisioningState(),
            customHttpsProvisioningSubstate = javaType.customHttpsProvisioningSubstate(),
            hostName = javaType.hostName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            resourceState = javaType.resourceState(),
            sessionAffinityEnabledState = javaType.sessionAffinityEnabledState().map({ args0 ->
                args0
            }).orElse(null),
            sessionAffinityTtlSeconds = javaType.sessionAffinityTtlSeconds().map({ args0 ->
                args0
            }).orElse(null),
            type = javaType.type(),
            webApplicationFirewallPolicyLink = javaType.webApplicationFirewallPolicyLink().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.FrontendEndpointUpdateParametersResponseWebApplicationFirewallPolicyLink.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
