@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Suppress

/**
 * Result of on demand test probe.
 * @property backendAddressPool Reference to an ApplicationGatewayBackendAddressPool resource.
 * @property backendHealthHttpSettings Application gateway BackendHealthHttp settings.
 */
public data class GetApplicationGatewayBackendHealthOnDemandResult(
    public val backendAddressPool: ApplicationGatewayBackendAddressPoolResponse? = null,
    public val backendHealthHttpSettings: ApplicationGatewayBackendHealthHttpSettingsResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetApplicationGatewayBackendHealthOnDemandResult): GetApplicationGatewayBackendHealthOnDemandResult =
            GetApplicationGatewayBackendHealthOnDemandResult(
                backendAddressPool = javaType.backendAddressPool().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayBackendAddressPoolResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                backendHealthHttpSettings = javaType.backendHealthHttpSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayBackendHealthHttpSettingsResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
