@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Bastion Host resource.
 * @property disableCopyPaste Enable/Disable Copy/Paste feature of the Bastion Host resource.
 * @property dnsName FQDN for the endpoint on which bastion host is accessible.
 * @property enableFileCopy Enable/Disable File Copy feature of the Bastion Host resource.
 * @property enableIpConnect Enable/Disable IP Connect feature of the Bastion Host resource.
 * @property enableKerberos Enable/Disable Kerberos feature of the Bastion Host resource.
 * @property enableShareableLink Enable/Disable Shareable Link of the Bastion Host resource.
 * @property enableTunneling Enable/Disable Tunneling feature of the Bastion Host resource.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property ipConfigurations IP configuration of the Bastion Host resource.
 * @property location Resource location.
 * @property name Resource name.
 * @property provisioningState The provisioning state of the bastion host resource.
 * @property scaleUnits The scale units for the Bastion Host resource.
 * @property sku The sku of this Bastion Host.
 * @property tags Resource tags.
 * @property type Resource type.
 */
public data class GetBastionHostResult(
    public val disableCopyPaste: Boolean? = null,
    public val dnsName: String? = null,
    public val enableFileCopy: Boolean? = null,
    public val enableIpConnect: Boolean? = null,
    public val enableKerberos: Boolean? = null,
    public val enableShareableLink: Boolean? = null,
    public val enableTunneling: Boolean? = null,
    public val etag: String,
    public val id: String? = null,
    public val ipConfigurations: List<BastionHostIPConfigurationResponse>? = null,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val scaleUnits: Int? = null,
    public val sku: SkuResponse? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetBastionHostResult): GetBastionHostResult = GetBastionHostResult(
            disableCopyPaste = javaType.disableCopyPaste().map({ args0 -> args0 }).orElse(null),
            dnsName = javaType.dnsName().map({ args0 -> args0 }).orElse(null),
            enableFileCopy = javaType.enableFileCopy().map({ args0 -> args0 }).orElse(null),
            enableIpConnect = javaType.enableIpConnect().map({ args0 -> args0 }).orElse(null),
            enableKerberos = javaType.enableKerberos().map({ args0 -> args0 }).orElse(null),
            enableShareableLink = javaType.enableShareableLink().map({ args0 -> args0 }).orElse(null),
            enableTunneling = javaType.enableTunneling().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            ipConfigurations = javaType.ipConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.BastionHostIPConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            scaleUnits = javaType.scaleUnits().map({ args0 -> args0 }).orElse(null),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
