@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Response for all the Bastion Shareable Link endpoints.
 * @property nextLink The URL to get the next set of results.
 * @property value List of Bastion Shareable Links for the request.
 */
public data class GetBastionShareableLinkResult(
    public val nextLink: String? = null,
    public val `value`: List<BastionShareableLinkResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetBastionShareableLinkResult): GetBastionShareableLinkResult = GetBastionShareableLinkResult(
            nextLink = javaType.nextLink().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.BastionShareableLinkResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
