@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The network manager connectivity configuration resource
 * @property appliesToGroups Groups for configuration
 * @property connectivityTopology Connectivity topology type.
 * @property deleteExistingPeering Flag if need to remove current existing peerings.
 * @property description A description of the connectivity configuration.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property hubs List of hubItems
 * @property id Resource ID.
 * @property isGlobal Flag if global mesh is supported.
 * @property name Resource name.
 * @property provisioningState The provisioning state of the connectivity configuration resource.
 * @property resourceGuid Unique identifier for this resource.
 * @property systemData The system metadata related to this resource.
 * @property type Resource type.
 */
public data class GetConnectivityConfigurationResult(
    public val appliesToGroups: List<ConnectivityGroupItemResponse>,
    public val connectivityTopology: String,
    public val deleteExistingPeering: String? = null,
    public val description: String? = null,
    public val etag: String,
    public val hubs: List<HubResponse>? = null,
    public val id: String,
    public val isGlobal: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val resourceGuid: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetConnectivityConfigurationResult): GetConnectivityConfigurationResult = GetConnectivityConfigurationResult(
            appliesToGroups = javaType.appliesToGroups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ConnectivityGroupItemResponse.Companion.toKotlin(args0)
                })
            }),
            connectivityTopology = javaType.connectivityTopology(),
            deleteExistingPeering = javaType.deleteExistingPeering().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            hubs = javaType.hubs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.HubResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            isGlobal = javaType.isGlobal().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            resourceGuid = javaType.resourceGuid(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
