@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Describes a DNS resolver.
 * @property dnsResolverState The current status of the DNS resolver. This is a read-only property and any attempt to set this value will be ignored.
 * @property etag ETag of the DNS resolver.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provisioningState The current provisioning state of the DNS resolver. This is a read-only property and any attempt to set this value will be ignored.
 * @property resourceGuid The resourceGuid property of the DNS resolver resource.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property virtualNetwork The reference to the virtual network. This cannot be changed after creation.
 */
public data class GetDnsResolverResult(
    public val dnsResolverState: String,
    public val etag: String,
    public val id: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val resourceGuid: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val virtualNetwork: SubResourceResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetDnsResolverResult): GetDnsResolverResult = GetDnsResolverResult(
            dnsResolverState = javaType.dnsResolverState(),
            etag = javaType.etag(),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            resourceGuid = javaType.resourceGuid(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            virtualNetwork = javaType.virtualNetwork().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
