@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Differentiated Services Code Point configuration for any given network interface
 * @property associatedNetworkInterfaces Associated Network Interfaces to the DSCP Configuration.
 * @property destinationIpRanges Destination IP ranges.
 * @property destinationPortRanges Destination port ranges.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property location Resource location.
 * @property markings List of markings to be used in the configuration.
 * @property name Resource name.
 * @property protocol RNM supported protocol types.
 * @property provisioningState The provisioning state of the DSCP Configuration resource.
 * @property qosCollectionId Qos Collection ID generated by RNM.
 * @property qosDefinitionCollection QoS object definitions
 * @property resourceGuid The resource GUID property of the DSCP Configuration resource.
 * @property sourceIpRanges Source IP ranges.
 * @property sourcePortRanges Sources port ranges.
 * @property tags Resource tags.
 * @property type Resource type.
 */
public data class GetDscpConfigurationResult(
    public val associatedNetworkInterfaces: List<NetworkInterfaceResponse>,
    public val destinationIpRanges: List<QosIpRangeResponse>? = null,
    public val destinationPortRanges: List<QosPortRangeResponse>? = null,
    public val etag: String,
    public val id: String? = null,
    public val location: String? = null,
    public val markings: List<Int>? = null,
    public val name: String,
    public val protocol: String? = null,
    public val provisioningState: String,
    public val qosCollectionId: String,
    public val qosDefinitionCollection: List<QosDefinitionResponse>? = null,
    public val resourceGuid: String,
    public val sourceIpRanges: List<QosIpRangeResponse>? = null,
    public val sourcePortRanges: List<QosPortRangeResponse>? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetDscpConfigurationResult): GetDscpConfigurationResult = GetDscpConfigurationResult(
            associatedNetworkInterfaces = javaType.associatedNetworkInterfaces().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.NetworkInterfaceResponse.Companion.toKotlin(args0)
                })
            }),
            destinationIpRanges = javaType.destinationIpRanges().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.QosIpRangeResponse.Companion.toKotlin(args0)
                })
            }),
            destinationPortRanges = javaType.destinationPortRanges().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.QosPortRangeResponse.Companion.toKotlin(args0)
                })
            }),
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            markings = javaType.markings().map({ args0 -> args0 }),
            name = javaType.name(),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            qosCollectionId = javaType.qosCollectionId(),
            qosDefinitionCollection = javaType.qosDefinitionCollection().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.QosDefinitionResponse.Companion.toKotlin(args0)
                })
            }),
            resourceGuid = javaType.resourceGuid(),
            sourceIpRanges = javaType.sourceIpRanges().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.QosIpRangeResponse.Companion.toKotlin(args0)
                })
            }),
            sourcePortRanges = javaType.sourcePortRanges().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.QosPortRangeResponse.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
