@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Class representing a Traffic Manager endpoint.
 * @property alwaysServe If Always Serve is enabled, probing for endpoint health will be disabled and endpoints will be included in the traffic routing method.
 * @property customHeaders List of custom headers.
 * @property endpointLocation Specifies the location of the external or nested endpoints when using the 'Performance' traffic routing method.
 * @property endpointMonitorStatus The monitoring status of the endpoint.
 * @property endpointStatus The status of the endpoint. If the endpoint is Enabled, it is probed for endpoint health and is included in the traffic routing method.
 * @property geoMapping The list of countries/regions mapped to this endpoint when using the 'Geographic' traffic routing method. Please consult Traffic Manager Geographic documentation for a full list of accepted values.
 * @property id Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}
 * @property minChildEndpoints The minimum number of endpoints that must be available in the child profile in order for the parent profile to be considered available. Only applicable to endpoint of type 'NestedEndpoints'.
 * @property minChildEndpointsIPv4 The minimum number of IPv4 (DNS record type A) endpoints that must be available in the child profile in order for the parent profile to be considered available. Only applicable to endpoint of type 'NestedEndpoints'.
 * @property minChildEndpointsIPv6 The minimum number of IPv6 (DNS record type AAAA) endpoints that must be available in the child profile in order for the parent profile to be considered available. Only applicable to endpoint of type 'NestedEndpoints'.
 * @property name The name of the resource
 * @property priority The priority of this endpoint when using the 'Priority' traffic routing method. Possible values are from 1 to 1000, lower values represent higher priority. This is an optional parameter.  If specified, it must be specified on all endpoints, and no two endpoints can share the same priority value.
 * @property subnets The list of subnets, IP addresses, and/or address ranges mapped to this endpoint when using the 'Subnet' traffic routing method. An empty list will match all ranges not covered by other endpoints.
 * @property target The fully-qualified DNS name or IP address of the endpoint. Traffic Manager returns this value in DNS responses to direct traffic to this endpoint.
 * @property targetResourceId The Azure Resource URI of the of the endpoint. Not applicable to endpoints of type 'ExternalEndpoints'.
 * @property type The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
 * @property weight The weight of this endpoint when using the 'Weighted' traffic routing method. Possible values are from 1 to 1000.
 */
public data class GetEndpointResult(
    public val alwaysServe: String? = null,
    public val customHeaders: List<EndpointPropertiesResponseCustomHeaders>? = null,
    public val endpointLocation: String? = null,
    public val endpointMonitorStatus: String? = null,
    public val endpointStatus: String? = null,
    public val geoMapping: List<String>? = null,
    public val id: String? = null,
    public val minChildEndpoints: Double? = null,
    public val minChildEndpointsIPv4: Double? = null,
    public val minChildEndpointsIPv6: Double? = null,
    public val name: String? = null,
    public val priority: Double? = null,
    public val subnets: List<EndpointPropertiesResponseSubnets>? = null,
    public val target: String? = null,
    public val targetResourceId: String? = null,
    public val type: String? = null,
    public val weight: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetEndpointResult): GetEndpointResult = GetEndpointResult(
            alwaysServe = javaType.alwaysServe().map({ args0 -> args0 }).orElse(null),
            customHeaders = javaType.customHeaders().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.EndpointPropertiesResponseCustomHeaders.Companion.toKotlin(args0)
                })
            }),
            endpointLocation = javaType.endpointLocation().map({ args0 -> args0 }).orElse(null),
            endpointMonitorStatus = javaType.endpointMonitorStatus().map({ args0 -> args0 }).orElse(null),
            endpointStatus = javaType.endpointStatus().map({ args0 -> args0 }).orElse(null),
            geoMapping = javaType.geoMapping().map({ args0 -> args0 }),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            minChildEndpoints = javaType.minChildEndpoints().map({ args0 -> args0 }).orElse(null),
            minChildEndpointsIPv4 = javaType.minChildEndpointsIPv4().map({ args0 -> args0 }).orElse(null),
            minChildEndpointsIPv6 = javaType.minChildEndpointsIPv6().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
            subnets = javaType.subnets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.EndpointPropertiesResponseSubnets.Companion.toKotlin(args0)
                })
            }),
            target = javaType.target().map({ args0 -> args0 }).orElse(null),
            targetResourceId = javaType.targetResourceId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            weight = javaType.weight().map({ args0 -> args0 }).orElse(null),
        )
    }
}
