@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Defines the properties of an Experiment
 * @property description The description of the details or intents of the Experiment
 * @property enabledState The state of the Experiment
 * @property endpointA The endpoint A of an experiment
 * @property endpointB The endpoint B of an experiment
 * @property id Resource ID.
 * @property location Resource location.
 * @property name Resource name.
 * @property resourceState Resource status.
 * @property scriptFileUri The uri to the Script used in the Experiment
 * @property status The description of Experiment status from the server side
 * @property tags Resource tags.
 * @property type Resource type.
 */
public data class GetExperimentResult(
    public val description: String? = null,
    public val enabledState: String? = null,
    public val endpointA: ExperimentEndpointResponse? = null,
    public val endpointB: ExperimentEndpointResponse? = null,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val resourceState: String,
    public val scriptFileUri: String,
    public val status: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetExperimentResult): GetExperimentResult = GetExperimentResult(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            enabledState = javaType.enabledState().map({ args0 -> args0 }).orElse(null),
            endpointA = javaType.endpointA().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ExperimentEndpointResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            endpointB = javaType.endpointB().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ExperimentEndpointResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            resourceState = javaType.resourceState(),
            scriptFileUri = javaType.scriptFileUri(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
