@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * ExpressRouteCircuit resource.
 * @property allowClassicOperations Allow classic operations.
 * @property authorizationKey The authorizationKey.
 * @property authorizationStatus The authorization status of the Circuit.
 * @property authorizations The list of authorizations.
 * @property bandwidthInGbps The bandwidth of the circuit when the circuit is provisioned on an ExpressRoutePort resource.
 * @property circuitProvisioningState The CircuitProvisioningState state of the resource.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property expressRoutePort The reference to the ExpressRoutePort resource when the circuit is provisioned on an ExpressRoutePort resource.
 * @property gatewayManagerEtag The GatewayManager Etag.
 * @property globalReachEnabled Flag denoting global reach status.
 * @property id Resource ID.
 * @property location Resource location.
 * @property name Resource name.
 * @property peerings The list of peerings.
 * @property provisioningState The provisioning state of the express route circuit resource.
 * @property serviceKey The ServiceKey.
 * @property serviceProviderNotes The ServiceProviderNotes.
 * @property serviceProviderProperties The ServiceProviderProperties.
 * @property serviceProviderProvisioningState The ServiceProviderProvisioningState state of the resource.
 * @property sku The SKU.
 * @property stag The identifier of the circuit traffic. Outer tag for QinQ encapsulation.
 * @property tags Resource tags.
 * @property type Resource type.
 */
public data class GetExpressRouteCircuitResult(
    public val allowClassicOperations: Boolean? = null,
    public val authorizationKey: String? = null,
    public val authorizationStatus: String,
    public val authorizations: List<ExpressRouteCircuitAuthorizationResponse>? = null,
    public val bandwidthInGbps: Double? = null,
    public val circuitProvisioningState: String? = null,
    public val etag: String,
    public val expressRoutePort: SubResourceResponse? = null,
    public val gatewayManagerEtag: String? = null,
    public val globalReachEnabled: Boolean? = null,
    public val id: String? = null,
    public val location: String? = null,
    public val name: String,
    public val peerings: List<ExpressRouteCircuitPeeringResponse>? = null,
    public val provisioningState: String,
    public val serviceKey: String? = null,
    public val serviceProviderNotes: String? = null,
    public val serviceProviderProperties: ExpressRouteCircuitServiceProviderPropertiesResponse? =
        null,
    public val serviceProviderProvisioningState: String? = null,
    public val sku: ExpressRouteCircuitSkuResponse? = null,
    public val stag: Int,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetExpressRouteCircuitResult): GetExpressRouteCircuitResult = GetExpressRouteCircuitResult(
            allowClassicOperations = javaType.allowClassicOperations().map({ args0 -> args0 }).orElse(null),
            authorizationKey = javaType.authorizationKey().map({ args0 -> args0 }).orElse(null),
            authorizationStatus = javaType.authorizationStatus(),
            authorizations = javaType.authorizations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteCircuitAuthorizationResponse.Companion.toKotlin(args0)
                })
            }),
            bandwidthInGbps = javaType.bandwidthInGbps().map({ args0 -> args0 }).orElse(null),
            circuitProvisioningState = javaType.circuitProvisioningState().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            expressRoutePort = javaType.expressRoutePort().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            gatewayManagerEtag = javaType.gatewayManagerEtag().map({ args0 -> args0 }).orElse(null),
            globalReachEnabled = javaType.globalReachEnabled().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            peerings = javaType.peerings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteCircuitPeeringResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            serviceKey = javaType.serviceKey().map({ args0 -> args0 }).orElse(null),
            serviceProviderNotes = javaType.serviceProviderNotes().map({ args0 -> args0 }).orElse(null),
            serviceProviderProperties = javaType.serviceProviderProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteCircuitServiceProviderPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            serviceProviderProvisioningState = javaType.serviceProviderProvisioningState().map({ args0 ->
                args0
            }).orElse(null),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteCircuitSkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            stag = javaType.stag(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
