@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * ExpressRouteConnection resource.
 * @property authorizationKey Authorization key to establish the connection.
 * @property enableInternetSecurity Enable internet security.
 * @property enablePrivateLinkFastPath Bypass the ExpressRoute gateway when accessing private-links. ExpressRoute FastPath (expressRouteGatewayBypass) must be enabled.
 * @property expressRouteCircuitPeering The ExpressRoute circuit peering.
 * @property expressRouteGatewayBypass Enable FastPath to vWan Firewall hub.
 * @property id Resource ID.
 * @property name The name of the resource.
 * @property provisioningState The provisioning state of the express route connection resource.
 * @property routingConfiguration The Routing Configuration indicating the associated and propagated route tables on this connection.
 * @property routingWeight The routing weight associated to the connection.
 */
public data class GetExpressRouteConnectionResult(
    public val authorizationKey: String? = null,
    public val enableInternetSecurity: Boolean? = null,
    public val enablePrivateLinkFastPath: Boolean? = null,
    public val expressRouteCircuitPeering: ExpressRouteCircuitPeeringIdResponse,
    public val expressRouteGatewayBypass: Boolean? = null,
    public val id: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val routingConfiguration: RoutingConfigurationResponse? = null,
    public val routingWeight: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetExpressRouteConnectionResult): GetExpressRouteConnectionResult = GetExpressRouteConnectionResult(
            authorizationKey = javaType.authorizationKey().map({ args0 -> args0 }).orElse(null),
            enableInternetSecurity = javaType.enableInternetSecurity().map({ args0 -> args0 }).orElse(null),
            enablePrivateLinkFastPath = javaType.enablePrivateLinkFastPath().map({ args0 ->
                args0
            }).orElse(null),
            expressRouteCircuitPeering = javaType.expressRouteCircuitPeering().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteCircuitPeeringIdResponse.Companion.toKotlin(args0)
            }),
            expressRouteGatewayBypass = javaType.expressRouteGatewayBypass().map({ args0 ->
                args0
            }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            routingConfiguration = javaType.routingConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.RoutingConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            routingWeight = javaType.routingWeight().map({ args0 -> args0 }).orElse(null),
        )
    }
}
