@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Peering in an ExpressRoute Cross Connection resource.
 * @property azureASN The Azure ASN.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property gatewayManagerEtag The GatewayManager Etag.
 * @property id Resource ID.
 * @property ipv6PeeringConfig The IPv6 peering configuration.
 * @property lastModifiedBy Who was the last to modify the peering.
 * @property microsoftPeeringConfig The Microsoft peering configuration.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property peerASN The peer ASN.
 * @property peeringType The peering type.
 * @property primaryAzurePort The primary port.
 * @property primaryPeerAddressPrefix The primary address prefix.
 * @property provisioningState The provisioning state of the express route cross connection peering resource.
 * @property secondaryAzurePort The secondary port.
 * @property secondaryPeerAddressPrefix The secondary address prefix.
 * @property sharedKey The shared key.
 * @property state The peering state.
 * @property vlanId The VLAN ID.
 */
public data class GetExpressRouteCrossConnectionPeeringResult(
    public val azureASN: Int,
    public val etag: String,
    public val gatewayManagerEtag: String? = null,
    public val id: String? = null,
    public val ipv6PeeringConfig: Ipv6ExpressRouteCircuitPeeringConfigResponse? = null,
    public val lastModifiedBy: String,
    public val microsoftPeeringConfig: ExpressRouteCircuitPeeringConfigResponse? = null,
    public val name: String? = null,
    public val peerASN: Double? = null,
    public val peeringType: String? = null,
    public val primaryAzurePort: String,
    public val primaryPeerAddressPrefix: String? = null,
    public val provisioningState: String,
    public val secondaryAzurePort: String,
    public val secondaryPeerAddressPrefix: String? = null,
    public val sharedKey: String? = null,
    public val state: String? = null,
    public val vlanId: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetExpressRouteCrossConnectionPeeringResult): GetExpressRouteCrossConnectionPeeringResult = GetExpressRouteCrossConnectionPeeringResult(
            azureASN = javaType.azureASN(),
            etag = javaType.etag(),
            gatewayManagerEtag = javaType.gatewayManagerEtag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            ipv6PeeringConfig = javaType.ipv6PeeringConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.Ipv6ExpressRouteCircuitPeeringConfigResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            lastModifiedBy = javaType.lastModifiedBy(),
            microsoftPeeringConfig = javaType.microsoftPeeringConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteCircuitPeeringConfigResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            peerASN = javaType.peerASN().map({ args0 -> args0 }).orElse(null),
            peeringType = javaType.peeringType().map({ args0 -> args0 }).orElse(null),
            primaryAzurePort = javaType.primaryAzurePort(),
            primaryPeerAddressPrefix = javaType.primaryPeerAddressPrefix().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            secondaryAzurePort = javaType.secondaryAzurePort(),
            secondaryPeerAddressPrefix = javaType.secondaryPeerAddressPrefix().map({ args0 ->
                args0
            }).orElse(null),
            sharedKey = javaType.sharedKey().map({ args0 -> args0 }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            vlanId = javaType.vlanId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
