@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * ExpressRoutePort Authorization resource definition.
 * @property authorizationKey The authorization key.
 * @property authorizationUseStatus The authorization use status.
 * @property circuitResourceUri The reference to the ExpressRoute circuit resource using the authorization.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property provisioningState The provisioning state of the authorization resource.
 * @property type Type of the resource.
 */
public data class GetExpressRoutePortAuthorizationResult(
    public val authorizationKey: String,
    public val authorizationUseStatus: String,
    public val circuitResourceUri: String,
    public val etag: String,
    public val id: String? = null,
    public val name: String? = null,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetExpressRoutePortAuthorizationResult): GetExpressRoutePortAuthorizationResult = GetExpressRoutePortAuthorizationResult(
            authorizationKey = javaType.authorizationKey(),
            authorizationUseStatus = javaType.authorizationUseStatus(),
            circuitResourceUri = javaType.circuitResourceUri(),
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            type = javaType.type(),
        )
    }
}
