@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Rule Collection Group resource.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property priority Priority of the Firewall Policy Rule Collection Group resource.
 * @property ruleCollections Group of Firewall Policy rule collections.
 * @property size A read-only string that represents the size of the FirewallPolicyRuleCollectionGroupProperties in MB. (ex 1.2MB)
 * @property type Rule Group type.
 */
public data class GetFirewallPolicyRuleCollectionGroupDraftResult(
    public val id: String? = null,
    public val name: String? = null,
    public val priority: Int? = null,
    public val ruleCollections: List<Either<FirewallPolicyFilterRuleCollectionResponse, FirewallPolicyNatRuleCollectionResponse>>? =
        null,
    public val size: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetFirewallPolicyRuleCollectionGroupDraftResult): GetFirewallPolicyRuleCollectionGroupDraftResult =
            GetFirewallPolicyRuleCollectionGroupDraftResult(
                id = javaType.id().map({ args0 -> args0 }).orElse(null),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
                ruleCollections = javaType.ruleCollections().map({ args0 ->
                    args0.transform(
                        { args0 ->
                            args0.let({ args0 ->
                                com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyFilterRuleCollectionResponse.Companion.toKotlin(args0)
                            })
                        },
                        { args0 ->
                            args0.let({ args0 ->
                                com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyNatRuleCollectionResponse.Companion.toKotlin(args0)
                            })
                        },
                    )
                }),
                size = javaType.size(),
                type = javaType.type(),
            )
    }
}
