@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Rule Collection Group resource.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property priority Priority of the Firewall Policy Rule Collection Group resource.
 * @property provisioningState The provisioning state of the firewall policy rule collection group resource.
 * @property ruleCollections Group of Firewall Policy rule collections.
 * @property type Rule Group type.
 */
public data class GetFirewallPolicyRuleCollectionGroupResult(
    public val etag: String,
    public val id: String? = null,
    public val name: String? = null,
    public val priority: Int? = null,
    public val provisioningState: String,
    public val ruleCollections: List<Either<FirewallPolicyFilterRuleCollectionResponse, FirewallPolicyNatRuleCollectionResponse>>? =
        null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetFirewallPolicyRuleCollectionGroupResult): GetFirewallPolicyRuleCollectionGroupResult = GetFirewallPolicyRuleCollectionGroupResult(
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            ruleCollections = javaType.ruleCollections().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyFilterRuleCollectionResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyNatRuleCollectionResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }),
            type = javaType.type(),
        )
    }
}
