@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Front Door represents a collection of backend endpoints to route traffic to along with rules that specify how traffic is sent there.
 * @property backendPools Backend pools available to routing rules.
 * @property backendPoolsSettings Settings for all backendPools
 * @property cname The host that each frontendEndpoint must CNAME to.
 * @property enabledState Operational status of the Front Door load balancer. Permitted values are 'Enabled' or 'Disabled'
 * @property extendedProperties Key-Value pair representing additional properties for frontdoor.
 * @property friendlyName A friendly name for the frontDoor
 * @property frontdoorId The Id of the frontdoor.
 * @property frontendEndpoints Frontend endpoints available to routing rules.
 * @property healthProbeSettings Health probe settings associated with this Front Door instance.
 * @property id Resource ID.
 * @property loadBalancingSettings Load balancing settings associated with this Front Door instance.
 * @property location Resource location.
 * @property name Resource name.
 * @property provisioningState Provisioning state of the Front Door.
 * @property resourceState Resource status of the Front Door.
 * @property routingRules Routing rules associated with this Front Door.
 * @property rulesEngines Rules Engine Configurations available to routing rules.
 * @property tags Resource tags.
 * @property type Resource type.
 */
public data class GetFrontDoorResult(
    public val backendPools: List<BackendPoolResponse>? = null,
    public val backendPoolsSettings: BackendPoolsSettingsResponse? = null,
    public val cname: String,
    public val enabledState: String? = null,
    public val extendedProperties: Map<String, String>,
    public val friendlyName: String? = null,
    public val frontdoorId: String,
    public val frontendEndpoints: List<FrontendEndpointResponse>? = null,
    public val healthProbeSettings: List<HealthProbeSettingsModelResponse>? = null,
    public val id: String,
    public val loadBalancingSettings: List<LoadBalancingSettingsModelResponse>? = null,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val resourceState: String,
    public val routingRules: List<RoutingRuleResponse>? = null,
    public val rulesEngines: List<RulesEngineResponse>,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetFrontDoorResult): GetFrontDoorResult = GetFrontDoorResult(
            backendPools = javaType.backendPools().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.BackendPoolResponse.Companion.toKotlin(args0)
                })
            }),
            backendPoolsSettings = javaType.backendPoolsSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.BackendPoolsSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            cname = javaType.cname(),
            enabledState = javaType.enabledState().map({ args0 -> args0 }).orElse(null),
            extendedProperties = javaType.extendedProperties().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            friendlyName = javaType.friendlyName().map({ args0 -> args0 }).orElse(null),
            frontdoorId = javaType.frontdoorId(),
            frontendEndpoints = javaType.frontendEndpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.FrontendEndpointResponse.Companion.toKotlin(args0)
                })
            }),
            healthProbeSettings = javaType.healthProbeSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.HealthProbeSettingsModelResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            loadBalancingSettings = javaType.loadBalancingSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.LoadBalancingSettingsModelResponse.Companion.toKotlin(args0)
                })
            }),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            resourceState = javaType.resourceState(),
            routingRules = javaType.routingRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.RoutingRuleResponse.Companion.toKotlin(args0)
                })
            }),
            rulesEngines = javaType.rulesEngines().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.RulesEngineResponse.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
