@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * RouteTable resource in a virtual hub.
 * @property associatedConnections List of all connections associated with this route table.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property labels List of labels associated with this route table.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property propagatingConnections List of all connections that advertise to this route table.
 * @property provisioningState The provisioning state of the RouteTable resource.
 * @property routes List of all routes.
 * @property type Resource type.
 */
public data class GetHubRouteTableResult(
    public val associatedConnections: List<String>,
    public val etag: String,
    public val id: String? = null,
    public val labels: List<String>? = null,
    public val name: String? = null,
    public val propagatingConnections: List<String>,
    public val provisioningState: String,
    public val routes: List<HubRouteResponse>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetHubRouteTableResult): GetHubRouteTableResult = GetHubRouteTableResult(
            associatedConnections = javaType.associatedConnections().map({ args0 -> args0 }),
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            labels = javaType.labels().map({ args0 -> args0 }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            propagatingConnections = javaType.propagatingConnections().map({ args0 -> args0 }),
            provisioningState = javaType.provisioningState(),
            routes = javaType.routes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.HubRouteResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
        )
    }
}
