@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * HubVirtualNetworkConnection Resource.
 * @property allowHubToRemoteVnetTransit Deprecated: VirtualHub to RemoteVnet transit to enabled or not.
 * @property allowRemoteVnetToUseHubVnetGateways Deprecated: Allow RemoteVnet to use Virtual Hub's gateways.
 * @property enableInternetSecurity Enable internet security.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property provisioningState The provisioning state of the hub virtual network connection resource.
 * @property remoteVirtualNetwork Reference to the remote virtual network.
 * @property routingConfiguration The Routing Configuration indicating the associated and propagated route tables on this connection.
 */
public data class GetHubVirtualNetworkConnectionResult(
    public val allowHubToRemoteVnetTransit: Boolean? = null,
    public val allowRemoteVnetToUseHubVnetGateways: Boolean? = null,
    public val enableInternetSecurity: Boolean? = null,
    public val etag: String,
    public val id: String? = null,
    public val name: String? = null,
    public val provisioningState: String,
    public val remoteVirtualNetwork: SubResourceResponse? = null,
    public val routingConfiguration: RoutingConfigurationResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetHubVirtualNetworkConnectionResult): GetHubVirtualNetworkConnectionResult = GetHubVirtualNetworkConnectionResult(
            allowHubToRemoteVnetTransit = javaType.allowHubToRemoteVnetTransit().map({ args0 ->
                args0
            }).orElse(null),
            allowRemoteVnetToUseHubVnetGateways = javaType.allowRemoteVnetToUseHubVnetGateways().map({ args0 ->
                args0
            }).orElse(null),
            enableInternetSecurity = javaType.enableInternetSecurity().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            remoteVirtualNetwork = javaType.remoteVirtualNetwork().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            routingConfiguration = javaType.routingConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.RoutingConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
