@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Inbound NAT rule of the load balancer.
 * @property backendAddressPool A reference to backendAddressPool resource.
 * @property backendIPConfiguration A reference to a private IP address defined on a network interface of a VM. Traffic sent to the frontend port of each of the frontend IP configurations is forwarded to the backend IP.
 * @property backendPort The port used for the internal endpoint. Acceptable values range from 1 to 65535.
 * @property enableFloatingIP Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
 * @property enableTcpReset Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property frontendIPConfiguration A reference to frontend IP addresses.
 * @property frontendPort The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values range from 1 to 65534.
 * @property frontendPortRangeEnd The port range end for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeStart. Individual inbound NAT rule port mappings will be created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534.
 * @property frontendPortRangeStart The port range start for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeEnd. Individual inbound NAT rule port mappings will be created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534.
 * @property id Resource ID.
 * @property idleTimeoutInMinutes The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
 * @property name The name of the resource that is unique within the set of inbound NAT rules used by the load balancer. This name can be used to access the resource.
 * @property protocol The reference to the transport protocol used by the load balancing rule.
 * @property provisioningState The provisioning state of the inbound NAT rule resource.
 * @property type Type of the resource.
 */
public data class GetInboundNatRuleResult(
    public val backendAddressPool: SubResourceResponse? = null,
    public val backendIPConfiguration: NetworkInterfaceIPConfigurationResponse,
    public val backendPort: Int? = null,
    public val enableFloatingIP: Boolean? = null,
    public val enableTcpReset: Boolean? = null,
    public val etag: String,
    public val frontendIPConfiguration: SubResourceResponse? = null,
    public val frontendPort: Int? = null,
    public val frontendPortRangeEnd: Int? = null,
    public val frontendPortRangeStart: Int? = null,
    public val id: String? = null,
    public val idleTimeoutInMinutes: Int? = null,
    public val name: String? = null,
    public val protocol: String? = null,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetInboundNatRuleResult): GetInboundNatRuleResult = GetInboundNatRuleResult(
            backendAddressPool = javaType.backendAddressPool().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            backendIPConfiguration = javaType.backendIPConfiguration().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.NetworkInterfaceIPConfigurationResponse.Companion.toKotlin(args0)
            }),
            backendPort = javaType.backendPort().map({ args0 -> args0 }).orElse(null),
            enableFloatingIP = javaType.enableFloatingIP().map({ args0 -> args0 }).orElse(null),
            enableTcpReset = javaType.enableTcpReset().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            frontendIPConfiguration = javaType.frontendIPConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            frontendPort = javaType.frontendPort().map({ args0 -> args0 }).orElse(null),
            frontendPortRangeEnd = javaType.frontendPortRangeEnd().map({ args0 -> args0 }).orElse(null),
            frontendPortRangeStart = javaType.frontendPortRangeStart().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            idleTimeoutInMinutes = javaType.idleTimeoutInMinutes().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            type = javaType.type(),
        )
    }
}
