@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Interface endpoint resource.
 * @property endpointService A reference to the service being brought into the virtual network.
 * @property etag Gets a unique read-only string that changes whenever the resource is updated.
 * @property fqdn A first-party service's FQDN that is mapped to the private IP allocated via this interface endpoint.
 * @property id Resource ID.
 * @property location Resource location.
 * @property name Resource name.
 * @property networkInterfaces Gets an array of references to the network interfaces created for this interface endpoint.
 * @property owner A read-only property that identifies who created this interface endpoint.
 * @property provisioningState The provisioning state of the interface endpoint. Possible values are: 'Updating', 'Deleting', and 'Failed'.
 * @property subnet The ID of the subnet from which the private IP will be allocated.
 * @property tags Resource tags.
 * @property type Resource type.
 */
public data class GetInterfaceEndpointResult(
    public val endpointService: EndpointServiceResponse? = null,
    public val etag: String? = null,
    public val fqdn: String? = null,
    public val id: String? = null,
    public val location: String? = null,
    public val name: String,
    public val networkInterfaces: List<NetworkInterfaceResponse>,
    public val owner: String,
    public val provisioningState: String,
    public val subnet: SubnetResponse? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetInterfaceEndpointResult): GetInterfaceEndpointResult = GetInterfaceEndpointResult(
            endpointService = javaType.endpointService().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.EndpointServiceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            fqdn = javaType.fqdn().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            networkInterfaces = javaType.networkInterfaces().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.NetworkInterfaceResponse.Companion.toKotlin(args0)
                })
            }),
            owner = javaType.owner(),
            provisioningState = javaType.provisioningState(),
            subnet = javaType.subnet().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubnetResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
