@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The IpGroups resource information.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property firewallPolicies List of references to Firewall Policies resources that this IpGroups is associated with.
 * @property firewalls List of references to Firewall resources that this IpGroups is associated with.
 * @property id Resource ID.
 * @property ipAddresses IpAddresses/IpAddressPrefixes in the IpGroups resource.
 * @property location Resource location.
 * @property name Resource name.
 * @property provisioningState The provisioning state of the IpGroups resource.
 * @property tags Resource tags.
 * @property type Resource type.
 */
public data class GetIpGroupResult(
    public val etag: String,
    public val firewallPolicies: List<SubResourceResponse>,
    public val firewalls: List<SubResourceResponse>,
    public val id: String? = null,
    public val ipAddresses: List<String>? = null,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetIpGroupResult): GetIpGroupResult = GetIpGroupResult(
            etag = javaType.etag(),
            firewallPolicies = javaType.firewallPolicies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            firewalls = javaType.firewalls().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            ipAddresses = javaType.ipAddresses().map({ args0 -> args0 }),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
