@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * LoadBalancer resource.
 * @property backendAddressPools Collection of backend address pools used by a load balancer.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property extendedLocation The extended location of the load balancer.
 * @property frontendIPConfigurations Object representing the frontend IPs to be used for the load balancer.
 * @property id Resource ID.
 * @property inboundNatPools Defines an external port range for inbound NAT to a single backend port on NICs associated with a load balancer. Inbound NAT rules are created automatically for each NIC associated with the Load Balancer using an external port from this range. Defining an Inbound NAT pool on your Load Balancer is mutually exclusive with defining inbound NAT rules. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an inbound NAT pool. They have to reference individual inbound NAT rules.
 * @property inboundNatRules Collection of inbound NAT Rules used by a load balancer. Defining inbound NAT rules on your load balancer is mutually exclusive with defining an inbound NAT pool. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an Inbound NAT pool. They have to reference individual inbound NAT rules.
 * @property loadBalancingRules Object collection representing the load balancing rules Gets the provisioning.
 * @property location Resource location.
 * @property name Resource name.
 * @property outboundRules The outbound rules.
 * @property probes Collection of probe objects used in the load balancer.
 * @property provisioningState The provisioning state of the load balancer resource.
 * @property resourceGuid The resource GUID property of the load balancer resource.
 * @property sku The load balancer SKU.
 * @property tags Resource tags.
 * @property type Resource type.
 */
public data class GetLoadBalancerResult(
    public val backendAddressPools: List<BackendAddressPoolResponse>? = null,
    public val etag: String,
    public val extendedLocation: ExtendedLocationResponse? = null,
    public val frontendIPConfigurations: List<FrontendIPConfigurationResponse>? = null,
    public val id: String? = null,
    public val inboundNatPools: List<InboundNatPoolResponse>? = null,
    public val inboundNatRules: List<InboundNatRuleResponse>? = null,
    public val loadBalancingRules: List<LoadBalancingRuleResponse>? = null,
    public val location: String? = null,
    public val name: String,
    public val outboundRules: List<OutboundRuleResponse>? = null,
    public val probes: List<ProbeResponse>? = null,
    public val provisioningState: String,
    public val resourceGuid: String,
    public val sku: LoadBalancerSkuResponse? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetLoadBalancerResult): GetLoadBalancerResult = GetLoadBalancerResult(
            backendAddressPools = javaType.backendAddressPools().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.BackendAddressPoolResponse.Companion.toKotlin(args0)
                })
            }),
            etag = javaType.etag(),
            extendedLocation = javaType.extendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            frontendIPConfigurations = javaType.frontendIPConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.FrontendIPConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            inboundNatPools = javaType.inboundNatPools().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.InboundNatPoolResponse.Companion.toKotlin(args0)
                })
            }),
            inboundNatRules = javaType.inboundNatRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.InboundNatRuleResponse.Companion.toKotlin(args0)
                })
            }),
            loadBalancingRules = javaType.loadBalancingRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.LoadBalancingRuleResponse.Companion.toKotlin(args0)
                })
            }),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            outboundRules = javaType.outboundRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.OutboundRuleResponse.Companion.toKotlin(args0)
                })
            }),
            probes = javaType.probes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ProbeResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            resourceGuid = javaType.resourceGuid(),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.LoadBalancerSkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
