@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * VpnGatewayNatRule Resource.
 * @property egressVpnSiteLinkConnections List of egress VpnSiteLinkConnections.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property externalMappings The private IP address external mapping for NAT.
 * @property id Resource ID.
 * @property ingressVpnSiteLinkConnections List of ingress VpnSiteLinkConnections.
 * @property internalMappings The private IP address internal mapping for NAT.
 * @property ipConfigurationId The IP Configuration ID this NAT rule applies to.
 * @property mode The Source NAT direction of a VPN NAT.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property provisioningState The provisioning state of the NAT Rule resource.
 * @property type Resource type.
 */
public data class GetNatRuleResult(
    public val egressVpnSiteLinkConnections: List<SubResourceResponse>,
    public val etag: String,
    public val externalMappings: List<VpnNatRuleMappingResponse>? = null,
    public val id: String? = null,
    public val ingressVpnSiteLinkConnections: List<SubResourceResponse>,
    public val internalMappings: List<VpnNatRuleMappingResponse>? = null,
    public val ipConfigurationId: String? = null,
    public val mode: String? = null,
    public val name: String? = null,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetNatRuleResult): GetNatRuleResult = GetNatRuleResult(
            egressVpnSiteLinkConnections = javaType.egressVpnSiteLinkConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            etag = javaType.etag(),
            externalMappings = javaType.externalMappings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.VpnNatRuleMappingResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            ingressVpnSiteLinkConnections = javaType.ingressVpnSiteLinkConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            internalMappings = javaType.internalMappings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.VpnNatRuleMappingResponse.Companion.toKotlin(args0)
                })
            }),
            ipConfigurationId = javaType.ipConfigurationId().map({ args0 -> args0 }).orElse(null),
            mode = javaType.mode().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            type = javaType.type(),
        )
    }
}
