@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Defines an Network Experiment Profile and lists of Experiments
 * @property enabledState The state of the Experiment
 * @property etag Gets a unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property location Resource location.
 * @property name Resource name.
 * @property resourceState Resource status.
 * @property tags Resource tags.
 * @property type Resource type.
 */
public data class GetNetworkExperimentProfileResult(
    public val enabledState: String? = null,
    public val etag: String? = null,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val resourceState: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetNetworkExperimentProfileResult): GetNetworkExperimentProfileResult = GetNetworkExperimentProfileResult(
            enabledState = javaType.enabledState().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            resourceState = javaType.resourceState(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
