@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The Managed Network resource
 * @property description A description of the network manager.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property location Resource location.
 * @property name Resource name.
 * @property networkManagerScopeAccesses Scope Access.
 * @property networkManagerScopes Scope of Network Manager.
 * @property provisioningState The provisioning state of the network manager resource.
 * @property resourceGuid Unique identifier for this resource.
 * @property systemData The system metadata related to this resource.
 * @property tags Resource tags.
 * @property type Resource type.
 */
public data class GetNetworkManagerResult(
    public val description: String? = null,
    public val etag: String,
    public val id: String? = null,
    public val location: String? = null,
    public val name: String,
    public val networkManagerScopeAccesses: List<String>,
    public val networkManagerScopes: NetworkManagerPropertiesResponseNetworkManagerScopes,
    public val provisioningState: String,
    public val resourceGuid: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetNetworkManagerResult): GetNetworkManagerResult = GetNetworkManagerResult(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            networkManagerScopeAccesses = javaType.networkManagerScopeAccesses().map({ args0 -> args0 }),
            networkManagerScopes = javaType.networkManagerScopes().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.NetworkManagerPropertiesResponseNetworkManagerScopes.Companion.toKotlin(args0)
            }),
            provisioningState = javaType.provisioningState(),
            resourceGuid = javaType.resourceGuid(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
