@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * NetworkSecurityGroup resource.
 * @property defaultSecurityRules The default security rules of network security group.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property flowLogs A collection of references to flow log resources.
 * @property flushConnection When enabled, flows created from Network Security Group connections will be re-evaluated when rules are updates. Initial enablement will trigger re-evaluation.
 * @property id Resource ID.
 * @property location Resource location.
 * @property name Resource name.
 * @property networkInterfaces A collection of references to network interfaces.
 * @property provisioningState The provisioning state of the network security group resource.
 * @property resourceGuid The resource GUID property of the network security group resource.
 * @property securityRules A collection of security rules of the network security group.
 * @property subnets A collection of references to subnets.
 * @property tags Resource tags.
 * @property type Resource type.
 */
public data class GetNetworkSecurityGroupResult(
    public val defaultSecurityRules: List<SecurityRuleResponse>,
    public val etag: String,
    public val flowLogs: List<FlowLogResponse>,
    public val flushConnection: Boolean? = null,
    public val id: String? = null,
    public val location: String? = null,
    public val name: String,
    public val networkInterfaces: List<NetworkInterfaceResponse>,
    public val provisioningState: String,
    public val resourceGuid: String,
    public val securityRules: List<SecurityRuleResponse>? = null,
    public val subnets: List<SubnetResponse>,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetNetworkSecurityGroupResult): GetNetworkSecurityGroupResult = GetNetworkSecurityGroupResult(
            defaultSecurityRules = javaType.defaultSecurityRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SecurityRuleResponse.Companion.toKotlin(args0)
                })
            }),
            etag = javaType.etag(),
            flowLogs = javaType.flowLogs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.FlowLogResponse.Companion.toKotlin(args0)
                })
            }),
            flushConnection = javaType.flushConnection().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            networkInterfaces = javaType.networkInterfaces().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.NetworkInterfaceResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            resourceGuid = javaType.resourceGuid(),
            securityRules = javaType.securityRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SecurityRuleResponse.Companion.toKotlin(args0)
                })
            }),
            subnets = javaType.subnets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubnetResponse.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
