@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The NSP access rule resource
 * @property addressPrefixes Inbound address prefixes (IPv4/IPv6)
 * @property direction Direction that specifies whether the access rules is inbound/outbound.
 * @property emailAddresses Outbound rules email address format.
 * @property fullyQualifiedDomainNames Outbound rules fully qualified domain name format.
 * @property id Resource ID.
 * @property location Resource location.
 * @property name Resource name.
 * @property networkSecurityPerimeters Rule specified by the perimeter id.
 * @property phoneNumbers Outbound rules phone number format.
 * @property provisioningState The provisioning state of the scope assignment resource.
 * @property subscriptions List of subscription ids
 * @property tags Resource tags.
 * @property type Resource type.
 */
public data class GetNspAccessRuleResult(
    public val addressPrefixes: List<String>? = null,
    public val direction: String? = null,
    public val emailAddresses: List<String>? = null,
    public val fullyQualifiedDomainNames: List<String>? = null,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val networkSecurityPerimeters: List<PerimeterBasedAccessRuleResponse>,
    public val phoneNumbers: List<String>? = null,
    public val provisioningState: String,
    public val subscriptions: List<SubscriptionIdResponse>? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetNspAccessRuleResult): GetNspAccessRuleResult = GetNspAccessRuleResult(
            addressPrefixes = javaType.addressPrefixes().map({ args0 -> args0 }),
            direction = javaType.direction().map({ args0 -> args0 }).orElse(null),
            emailAddresses = javaType.emailAddresses().map({ args0 -> args0 }),
            fullyQualifiedDomainNames = javaType.fullyQualifiedDomainNames().map({ args0 -> args0 }),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            networkSecurityPerimeters = javaType.networkSecurityPerimeters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.PerimeterBasedAccessRuleResponse.Companion.toKotlin(args0)
                })
            }),
            phoneNumbers = javaType.phoneNumbers().map({ args0 -> args0 }),
            provisioningState = javaType.provisioningState(),
            subscriptions = javaType.subscriptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubscriptionIdResponse.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
