@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The NSP resource association resource
 * @property accessMode Access mode on the association.
 * @property hasProvisioningIssues Specifies if there are provisioning issues
 * @property id Resource ID.
 * @property location Resource location.
 * @property name Resource name.
 * @property privateLinkResource The PaaS resource to be associated.
 * @property profile Profile id to which the PaaS resource is associated.
 * @property provisioningState The provisioning state of the resource  association resource.
 * @property tags Resource tags.
 * @property type Resource type.
 */
public data class GetNspAssociationResult(
    public val accessMode: String? = null,
    public val hasProvisioningIssues: String,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val privateLinkResource: SubResourceResponse? = null,
    public val profile: SubResourceResponse? = null,
    public val provisioningState: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetNspAssociationResult): GetNspAssociationResult = GetNspAssociationResult(
            accessMode = javaType.accessMode().map({ args0 -> args0 }).orElse(null),
            hasProvisioningIssues = javaType.hasProvisioningIssues(),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            privateLinkResource = javaType.privateLinkResource().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            profile = javaType.profile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
