@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The network security perimeter link resource
 * @property autoApprovedRemotePerimeterResourceId Perimeter ARM Id for the remote NSP with which the link gets created in Auto-approval mode. It should be used when the NSP admin have Microsoft.Network/networkSecurityPerimeters/linkPerimeter/action permission on the remote NSP resource.
 * @property description A message passed to the owner of the remote NSP link resource with this connection request. In case of Auto-approved flow, it is default to 'Auto Approved'. Restricted to 140 chars.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property localInboundProfiles Local Inbound profile names to which Inbound is allowed. Use ['*'] to allow inbound to all profiles&#46; It's default value is ['*'].
 * @property localOutboundProfiles Local Outbound profile names from which Outbound is allowed. In current version, it is readonly property and it's value is set to ['*'] to allow outbound from all profiles. In later version, user will be able to modify it.
 * @property name Resource name.
 * @property provisioningState The provisioning state of the NSP Link resource.
 * @property remoteInboundProfiles Remote Inbound profile names to which Inbound is allowed. Use ['*'] to allow inbound to all profiles&#46; This property can only be updated in auto-approval mode&#46; It's default value is ['*'].
 * @property remoteOutboundProfiles Remote Outbound profile names from which Outbound is allowed. In current version, it is readonly property and it's value is set to ['*'] to allow outbound from all profiles. In later version, user will be able to modify it.
 * @property remotePerimeterGuid Remote NSP Guid with which the link gets created.
 * @property remotePerimeterLocation Remote NSP location with which the link gets created.
 * @property status The NSP link state.
 * @property type Resource type.
 */
public data class GetNspLinkResult(
    public val autoApprovedRemotePerimeterResourceId: String? = null,
    public val description: String? = null,
    public val etag: String,
    public val id: String,
    public val localInboundProfiles: List<String>? = null,
    public val localOutboundProfiles: List<String>,
    public val name: String,
    public val provisioningState: String,
    public val remoteInboundProfiles: List<String>? = null,
    public val remoteOutboundProfiles: List<String>,
    public val remotePerimeterGuid: String,
    public val remotePerimeterLocation: String,
    public val status: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetNspLinkResult): GetNspLinkResult = GetNspLinkResult(
            autoApprovedRemotePerimeterResourceId = javaType.autoApprovedRemotePerimeterResourceId().map({ args0 ->
                args0
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id(),
            localInboundProfiles = javaType.localInboundProfiles().map({ args0 -> args0 }),
            localOutboundProfiles = javaType.localOutboundProfiles().map({ args0 -> args0 }),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            remoteInboundProfiles = javaType.remoteInboundProfiles().map({ args0 -> args0 }),
            remoteOutboundProfiles = javaType.remoteOutboundProfiles().map({ args0 -> args0 }),
            remotePerimeterGuid = javaType.remotePerimeterGuid(),
            remotePerimeterLocation = javaType.remotePerimeterLocation(),
            status = javaType.status(),
            type = javaType.type(),
        )
    }
}
